 /********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Businessanalystteam.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include <math.h>            // fabs( ... )
#include <stdlib.h>
#include "randlib.h"


/*******************************************************************
* Function Name: Businessanalystteam
* Description: constructor
********************************************************************/
Businessanalystteam::Businessanalystteam( const string &name )
: Atomic( name )
, bustimeout(addOutputPort( "bustimeout" ))
, bustimein(addInputPort( "bustimein" ))
, changein(addOutputPort( "changein" ))
, changeout(addInputPort( "changeout" ))
, preparationTime( 0, 0, 0, 0 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Businessanalystteam::initFunction()
{
	change = 0;
	totreqtime = 0;
	randnumber = 0;
	this->passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Businessanalystteam::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	

	this->sigma = nextChange();
	this->elapsed = msg.time()-lastChange();
	this->timeLeft = this->sigma - this->elapsed;
	
 	int co = 0;
	int reqt = 0;

	if(msg.port() == changeout){
		co = msg.value();
	}
	if(msg.port() == bustimein){
		reqt = msg.value();
	}
 if ( this->state() == passive )
 {
		randnumber = rand() % 100;
		if (randnumber < 60){
			change = 1;
			totreqtime = reqt+(reqt/2);
			cout<<"totReqtime1:  "<<totreqtime<<"\n";
			holdIn( active, preparationTime );
		}else{
			change = 0;
			totreqtime = reqt;
			cout<<"totReqtime2:  "<<totreqtime<<"\n";
			holdIn( active, preparationTime );
		}

}
	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Businessanalystteam::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here
	//passivate();

	change = 0;
	totreqtime = 0;
	randnumber = 0;
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn(passive, this->sigma );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Businessanalystteam::outputFunction( const InternalMessage &msg )
{
	//TODO: implement the output function here
	// remember you can use sendOutput(time, outputPort, value) function.
	// sendOutput( msg.time(), out, 1) ;
	if(totreqtime != 0)
		sendOutput( msg.time(), bustimeout , totreqtime ) ;
	 if(change == 1)
		 sendOutput( msg.time(), changein , change ) ;
	
	return *this;

}

Businessanalystteam::~Businessanalystteam()
{
	//TODO: add destruction code here. Free distribution memory, etc. 
}
